<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
require_admin($me);

$q = isset($_GET['q']) ? trim((string)$_GET['q']) : '';
$departmentId = isset($_GET['departmentId']) ? trim((string)$_GET['departmentId']) : '';
$courseId = isset($_GET['courseId']) ? trim((string)$_GET['courseId']) : '';

// base query
$where = ['u.role = \'course_rep\''];
$params = [];

if ($q !== '') {
  $where[] = '(u.full_name LIKE :q OR u.email LIKE :q)';
  $params[':q'] = '%' . $q . '%';
}

$joins = "";
if ($departmentId !== '') {
  $joins .= " LEFT JOIN profiles p ON p.user_id = u.id ";
  $where[] = 'p.department_id = :dept';
  $params[':dept'] = $departmentId;
}

if ($courseId !== '') {
  $joins .= " INNER JOIN course_rep_courses crc_filter ON crc_filter.user_id = u.id AND crc_filter.course_id = :cid ";
  $params[':cid'] = $courseId;
}

try {
  // ensure optional flags table
  ensure_course_rep_flags_table($pdo);
} catch (Throwable $e) {
  // ignore
}

$sql = 'SELECT u.id, u.full_name AS fullName, u.email, u.role,
               COALESCE(f.uploads_disabled, 0) AS uploadsDisabled
        FROM users u
        ' . $joins . '
        LEFT JOIN course_rep_flags f ON f.user_id = u.id
        WHERE ' . implode(' AND ', $where) . '
        ORDER BY u.full_name ASC';

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$reps = $stmt->fetchAll() ?: [];

$ids = array_map(fn($r) => (string)$r['id'], $reps);
$assignmentsByUser = [];
if (count($ids)) {
  $in = implode(',', array_fill(0, count($ids), '?'));
  $stmt = $pdo->prepare('SELECT user_id, course_id AS courseId, assigned_at AS assignedAt, assigned_by AS assignedBy
                         FROM course_rep_courses
                         WHERE user_id IN (' . $in . ')
                         ORDER BY assigned_at DESC');
  $stmt->execute($ids);
  $rows = $stmt->fetchAll() ?: [];
  foreach ($rows as $r) {
    $uid = (string)$r['user_id'];
    if (!isset($assignmentsByUser[$uid])) $assignmentsByUser[$uid] = [];
    $assignmentsByUser[$uid][] = [
      'courseId' => (string)$r['courseId'],
      'assignedAt' => $r['assignedAt'],
      'assignedBy' => $r['assignedBy'],
    ];
  }
}

$out = array_map(function($r) use ($assignmentsByUser) {
  $uid = (string)$r['id'];
  return [
    'id' => $uid,
    'fullName' => $r['fullName'],
    'email' => $r['email'],
    'role' => $r['role'],
    'uploadsDisabled' => (int)($r['uploadsDisabled'] ?? 0) === 1,
    'assignments' => $assignmentsByUser[$uid] ?? [],
  ];
}, $reps);

json_response(['success' => true, 'data' => ['courseReps' => $out]]);
