<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
require_admin($me);

$body = read_json();
require_fields($body, ['userId', 'courseId']);

$userId = trim((string)$body['userId']);
$courseId = trim((string)$body['courseId']);
if ($userId === '' || $courseId === '') {
  json_response(['success' => false, 'error' => 'Missing userId/courseId'], 422);
}

// ensure the user is a course_rep
$stmt = $pdo->prepare('SELECT role FROM users WHERE id = :id LIMIT 1');
$stmt->execute([':id' => $userId]);
$role = (string)($stmt->fetchColumn() ?: '');
if ($role !== 'course_rep') {
  json_response(['success' => false, 'error' => 'User is not a course rep'], 409);
}

try {
  $stmt = $pdo->prepare('INSERT IGNORE INTO course_rep_courses (id, user_id, course_id, assigned_by, assigned_at)
                         VALUES (:id,:uid,:cid,:by,UTC_TIMESTAMP())');
  $stmt->execute([
    ':id' => uuidv4(),
    ':uid' => $userId,
    ':cid' => $courseId,
    ':by' => $me['id'],
  ]);
} catch (Throwable $e) {
  json_response(['success' => false, 'error' => 'Failed to assign course'], 500);
}

upload_audit_log($pdo, [
  'action' => 'assign',
  'entityType' => 'course_rep_course',
  'entityId' => $courseId,
  'courseId' => $courseId,
  'actorId' => (string)$me['id'],
  'targetUserId' => $userId,
  'details' => ['userId' => $userId, 'courseId' => $courseId]
]);

json_response(['success' => true, 'data' => ['assigned' => true]]);
