<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
require_admin($me);

$body = read_json();
require_fields($body, ['userId']);

$userId = trim((string)$body['userId']);
if ($userId === '') {
  json_response(['success' => false, 'error' => 'Missing userId'], 422);
}

try {
  $pdo->beginTransaction();
  $pdo->prepare('UPDATE users SET role = \"student\" WHERE id = :id')->execute([':id' => $userId]);
  $pdo->prepare('DELETE FROM course_rep_courses WHERE user_id = :uid')->execute([':uid' => $userId]);
  try {
    ensure_course_rep_flags_table($pdo);
    $pdo->prepare('DELETE FROM course_rep_flags WHERE user_id = :uid')->execute([':uid' => $userId]);
  } catch (Throwable $e) {
    // ignore
  }
  $pdo->commit();
} catch (Throwable $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  json_response(['success' => false, 'error' => 'Failed to suspend course rep'], 500);
}

upload_audit_log($pdo, [
  'action' => 'suspend',
  'entityType' => 'course_rep',
  'entityId' => $userId,
  'actorId' => (string)$me['id'],
  'targetUserId' => $userId,
  'details' => ['userId' => $userId]
]);

json_response(['success' => true, 'data' => ['suspended' => true]]);
