<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
require_admin($me);

$body = read_json();
require_fields($body, ['userId', 'courseId']);

$userId = trim((string)$body['userId']);
$courseId = trim((string)$body['courseId']);
if ($userId === '' || $courseId === '') {
  json_response(['success' => false, 'error' => 'Missing userId/courseId'], 422);
}

$pdo->prepare('DELETE FROM course_rep_courses WHERE user_id = :uid AND course_id = :cid')
    ->execute([':uid' => $userId, ':cid' => $courseId]);

upload_audit_log($pdo, [
  'action' => 'unassign',
  'entityType' => 'course_rep_course',
  'entityId' => $courseId,
  'courseId' => $courseId,
  'actorId' => (string)$me['id'],
  'targetUserId' => $userId,
  'details' => ['userId' => $userId, 'courseId' => $courseId]
]);

json_response(['success' => true, 'data' => ['unassigned' => true]]);
