<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
require_admin($me);

$body = read_json();
require_fields($body, ['requestId']);

$requestId = trim((string)$body['requestId']);
$adminNote = trim((string)($body['adminNote'] ?? ''));

if ($requestId === '') {
  json_response(['success' => false, 'error' => 'requestId is required'], 422);
}

try {
  $pdo->beginTransaction();

  $stmt = $pdo->prepare('SELECT * FROM course_rep_requests WHERE id = :id LIMIT 1 FOR UPDATE');
  $stmt->execute([':id' => $requestId]);
  $req = $stmt->fetch();
  if (!$req) {
    json_response(['success' => false, 'error' => 'Request not found'], 404);
  }
  if ((string)$req['status'] !== 'pending') {
    json_response(['success' => false, 'error' => 'Request is not pending'], 409);
  }

  $pdo->prepare('UPDATE course_rep_requests
                 SET status = "denied", reviewed_at = UTC_TIMESTAMP(), reviewed_by = :by, admin_note = :note
                 WHERE id = :id')
      ->execute([':by' => $me['id'], ':note' => ($adminNote !== '' ? $adminNote : null), ':id' => $requestId]);

  $pdo->commit();

  json_response(['success' => true, 'data' => ['denied' => true]]);
} catch (Throwable $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  json_response(['success' => false, 'error' => 'Failed to deny request'], 500);
}
