<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') json_response(['success'=>false,'error'=>'Method not allowed'],405);

$sql = 'SELECT c.id, c.code, c.title, c.level
        FROM courses c
        ORDER BY c.level, c.code';

// NOTE: This endpoint intentionally ignores departmentId/level filters.
// The app is in "global catalogue" mode where every user sees the same courses.
$stmt = $pdo->prepare($sql);
$stmt->execute([]);
$rows = $stmt->fetchAll() ?: [];

json_response(['success'=>true,'data'=>['courses'=>$rows]]);
