<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$sql = 'SELECT id, code, title, level
        FROM courses
        WHERE (UPPER(code) LIKE "GST%" OR UPPER(code) LIKE "GNS%")';

// NOTE: This endpoint intentionally ignores the `level` filter.
// The app is in "global catalogue" mode where every user sees the same GNS/GST courses.
$sql .= ' ORDER BY level, code';

$stmt = $pdo->prepare($sql);
$stmt->execute([]);
$rows = $stmt->fetchAll() ?: [];

json_response(['success' => true, 'data' => ['courses' => $rows]]);
