<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';
require_once __DIR__ . '/../groups/_helpers.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}
$me = require_auth($pdo);
$challengeId = trim((string)($_GET['challengeId'] ?? ''));
if ($challengeId === '') json_response(['success' => false, 'error' => 'Missing challengeId'], 422);

$ch = challenge_require_access($pdo, $challengeId, (string)$me['id']);

$qq = $pdo->prepare('SELECT question_id AS questionId, bank_id AS bankId, position FROM study_group_challenge_questions WHERE challenge_id = :id ORDER BY position ASC');
$qq->execute(['id' => $challengeId]);
$rows = $qq->fetchAll() ?: [];
if (count($rows) === 0) json_response(['success' => false, 'error' => 'Challenge has no questions'], 500);

$qids = array_map(fn($r) => (string)$r['questionId'], $rows);
$in = implode(',', array_fill(0, count($qids), '?'));
$stmt = $pdo->prepare('SELECT id, bank_id AS bankId, prompt, options FROM questions WHERE id IN (' . $in . ')');
$stmt->execute($qids);
$qrows = $stmt->fetchAll() ?: [];
$byId = [];
foreach ($qrows as $r) $byId[(string)$r['id']] = $r;

// ordered questions
$questions = [];
foreach ($rows as $r) {
  $qid = (string)$r['questionId'];
  $q = $byId[$qid] ?? null;
  if (!$q) continue;
  $questions[] = [
    'id' => (string)$q['id'],
    'bankId' => (string)$q['bankId'],
    'prompt' => (string)$q['prompt'],
    'options' => json_decode((string)$q['options'], true) ?: [],
  ];
}

$course = null;
try {
  $c = $pdo->prepare('SELECT id, code, title, level FROM courses WHERE id = :id LIMIT 1');
  $c->execute(['id' => (string)$ch['course_id']]);
  $course = $c->fetch() ?: null;
} catch (Throwable $e) {
  $course = null;
}

json_response([
  'success' => true,
  'data' => [
    'challenge' => [
      'id' => (string)$ch['id'],
      'groupId' => (string)$ch['group_id'],
      'groupName' => (string)($ch['groupName'] ?? ''),
      'title' => (string)$ch['title'],
      'courseId' => (string)$ch['course_id'],
      'courseCode' => (string)($course['code'] ?? ''),
      'courseTitle' => (string)($course['title'] ?? ''),
      'durationMins' => (int)($ch['duration_minutes'] ?? 20),
      'total' => (int)($ch['total_questions'] ?? count($questions)),
      'createdAt' => (string)($ch['created_at'] ?? ''),
    ],
    'questions' => $questions,
  ]
]);
