<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';
require_once __DIR__ . '/../groups/_helpers.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}
$me = require_auth($pdo);
$challengeId = trim((string)($_GET['challengeId'] ?? ''));
if ($challengeId === '') json_response(['success' => false, 'error' => 'Missing challengeId'], 422);

// access control
$ch = challenge_require_access($pdo, $challengeId, (string)$me['id']);

$sql = '
  SELECT
    a.user_id AS userId,
    u.full_name AS fullName,
    a.score_percent AS scorePercent,
    a.correct_count AS correct,
    a.total_questions AS total,
    a.seconds_total AS secondsTotal,
    a.submitted_at AS submittedAt
  FROM study_group_challenge_attempts a
  JOIN users u ON u.id = a.user_id
  WHERE a.challenge_id = :cid
  ORDER BY a.score_percent DESC, a.seconds_total ASC, a.submitted_at ASC
  LIMIT 100
';
$stmt = $pdo->prepare($sql);
$stmt->execute([':cid' => $challengeId]);
$rows = $stmt->fetchAll() ?: [];

$items = [];
$rank = 0;
foreach ($rows as $r) {
  $rank++;
  $items[] = [
    'rank' => $rank,
    'userId' => (string)$r['userId'],
    'fullName' => (string)$r['fullName'],
    'scorePercent' => (int)$r['scorePercent'],
    'correct' => (int)$r['correct'],
    'total' => (int)$r['total'],
    'secondsTotal' => (int)$r['secondsTotal'],
    'submittedAt' => (string)$r['submittedAt'],
    'isMe' => ((string)$r['userId'] === (string)$me['id']),
  ];
}

json_response(['success' => true, 'data' => ['challengeId' => (string)$ch['id'], 'items' => $items]]);
