<?php
declare(strict_types=1);

require_once __DIR__ . '/../helpers.php';

/**
 * Generate a short, human-shareable code.
 * Example: 8 chars uppercase hex.
 */
function duel_new_code(): string {
  return strtoupper(bin2hex(random_bytes(4))); // 8 chars
}

/**
 * Conservative internal id.
 */
function duel_new_id(): string {
  return 'duel_' . bin2hex(random_bytes(8));
}

function duel_safe_next_seconds(int $durationMins, ?string $startedAt): int {
  $total = max(60, $durationMins * 60);
  if (!$startedAt) return $total;
  $ts = strtotime($startedAt);
  if ($ts === false) return $total;
  $elapsed = time() - $ts;
  return max(0, $total - (int)$elapsed);
}
