<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';
require_once __DIR__ . '/_helpers.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
$code = trim((string)($_GET['code'] ?? ''));
if ($code === '') json_response(['success' => false, 'error' => 'Missing code'], 422);

$stmt = $pdo->prepare('
  SELECT d.id, d.code, d.bank_id AS bankId, b.title AS bankTitle, b.course_id AS courseId,
         d.created_by AS createdBy, d.status, d.question_count AS questionCount,
         d.duration_minutes AS durationMins, d.started_at AS startedAt, d.expires_at AS expiresAt,
         d.created_at AS createdAt, d.completed_at AS completedAt
  FROM duel_links d
  JOIN banks b ON b.id = d.bank_id
  WHERE d.code = :c
  LIMIT 1
');
$stmt->execute(['c' => $code]);
$d = $stmt->fetch();
if (!$d) json_response(['success' => false, 'error' => 'Duel link not found'], 404);

$p = $pdo->prepare('
  SELECT p.user_id AS userId, p.slot, p.score, p.seconds_total AS secondsTotal, p.submitted_at AS submittedAt,
         u.full_name AS fullName
  FROM duel_participants p
  JOIN users u ON u.id = p.user_id
  WHERE p.duel_id = :did
  ORDER BY p.slot ASC
');
$p->execute(['did' => (string)$d['id']]);
$parts = $p->fetchAll() ?: [];

$isParticipant = false;
foreach ($parts as $r) {
  if ((string)$r['userId'] === (string)$me['id']) { $isParticipant = true; break; }
}

$expiresAt = (string)($d['expiresAt'] ?? '');
$expired = $expiresAt !== '' && strtotime($expiresAt) !== false && strtotime($expiresAt) < time();
$canJoin = (!$expired) && ((string)$d['status'] !== 'completed') && (count($parts) < 2);

json_response([
  'success' => true,
  'data' => [
    'duel' => [
      'id' => (string)$d['id'],
      'code' => (string)$d['code'],
      'status' => (string)$d['status'],
      'bankId' => (string)$d['bankId'],
      'bankTitle' => (string)$d['bankTitle'],
      'courseId' => (string)$d['courseId'],
      'createdBy' => (string)$d['createdBy'],
      'questionCount' => (int)$d['questionCount'],
      'durationMins' => (int)$d['durationMins'],
      'startedAt' => $d['startedAt'] ? (string)$d['startedAt'] : null,
      'createdAt' => $d['createdAt'] ? (string)$d['createdAt'] : null,
      'expiresAt' => $d['expiresAt'] ? (string)$d['expiresAt'] : null,
      'completedAt' => $d['completedAt'] ? (string)$d['completedAt'] : null,
      'sharePath' => '/duel/' . (string)$d['code'],
      'remainingSeconds' => duel_safe_next_seconds((int)$d['durationMins'], $d['startedAt'] ? (string)$d['startedAt'] : null),
    ],
    'participants' => array_map(static function($r){
      return [
        'userId' => (string)$r['userId'],
        'fullName' => (string)($r['fullName'] ?? ''),
        'slot' => (int)($r['slot'] ?? 0),
        'score' => isset($r['score']) ? (int)$r['score'] : null,
        'secondsTotal' => isset($r['secondsTotal']) ? (int)$r['secondsTotal'] : null,
        'submittedAt' => $r['submittedAt'] ? (string)$r['submittedAt'] : null,
      ];
    }, $parts),
    'me' => [
      'isParticipant' => $isParticipant,
      'canJoin' => $canJoin,
      'expired' => $expired,
    ]
  ]
]);
