<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);

$examId = isset($_GET['examId']) ? trim((string)$_GET['examId']) : '';
if ($examId === '') json_response(['success' => false, 'error' => 'Missing examId'], 422);

$s = $pdo->prepare('SELECT id, course_id, total_questions, duration_minutes, started_at, submitted_at FROM exam_sessions WHERE id = :id AND user_id = :uid LIMIT 1');
$s->execute(['id' => $examId, 'uid' => $me['id']]);
$session = $s->fetch();
if (!$session) json_response(['success' => false, 'error' => 'Exam not found'], 404);

$courseId = (string)$session['course_id'];
$c = $pdo->prepare('SELECT id, code, title, level FROM courses WHERE id = :id LIMIT 1');
$c->execute(['id' => $courseId]);
$course = $c->fetch() ?: ['id' => $courseId, 'code' => $courseId, 'title' => '', 'level' => 0];

$qq = $pdo->prepare('SELECT question_id AS questionId, bank_id AS bankId, position FROM exam_session_questions WHERE exam_id = :id ORDER BY position ASC');
$qq->execute(['id' => $examId]);
$examQuestions = $qq->fetchAll() ?: [];

if (count($examQuestions) === 0) json_response(['success' => false, 'error' => 'Exam has no questions'], 500);

$qids = array_map(fn($r) => (string)$r['questionId'], $examQuestions);
$in = implode(',', array_fill(0, count($qids), '?'));

$stmt = $pdo->prepare(
  'SELECT q.id, q.bank_id AS bankId, q.prompt, q.options
   FROM questions q
   WHERE q.id IN (' . $in . ')'
);
$stmt->execute($qids);
$rows = $stmt->fetchAll() ?: [];

$byId = [];
foreach ($rows as $r) $byId[(string)$r['id']] = $r;

$questions = [];
foreach ($examQuestions as $r) {
  $qid = (string)$r['questionId'];
  $qrow = $byId[$qid] ?? null;
  if (!$qrow) continue;
  $questions[] = [
    'id' => (string)$qrow['id'],
    'bankId' => (string)$qrow['bankId'],
    'prompt' => (string)$qrow['prompt'],
    'options' => json_decode((string)$qrow['options'], true) ?: [],
  ];
}

json_response([
  'success' => true,
  'data' => [
    'exam' => [
      'id' => (string)$examId,
      'courseId' => $courseId,
      'courseCode' => (string)($course['code'] ?? $courseId),
      'courseTitle' => (string)($course['title'] ?? ''),
      'durationMins' => (int)($session['duration_minutes'] ?? 60),
      'total' => (int)($session['total_questions'] ?? count($questions)),
      'startedAt' => (string)($session['started_at'] ?? ''),
      'submittedAt' => (string)($session['submitted_at'] ?? ''),
    ],
    'questions' => $questions,
  ]
]);
