<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);

$examId = isset($_GET['examId']) ? trim((string)$_GET['examId']) : '';
if ($examId === '') json_response(['success' => false, 'error' => 'Missing examId'], 422);

$s = $pdo->prepare('SELECT * FROM exam_sessions WHERE id = :id AND user_id = :uid LIMIT 1');
$s->execute(['id' => $examId, 'uid' => $me['id']]);
$session = $s->fetch();
if (!$session) json_response(['success' => false, 'error' => 'Exam not found'], 404);

if (empty($session['submitted_at'])) {
  json_response(['success' => false, 'error' => 'Exam not submitted yet'], 409);
}

$courseId = (string)($session['course_id'] ?? '');

// Wrong review: derive from attempts saved during submit
$qq = $pdo->prepare('SELECT question_id AS questionId, bank_id AS bankId, position FROM exam_session_questions WHERE exam_id = :id ORDER BY position ASC');
$qq->execute(['id' => $examId]);
$eq = $qq->fetchAll() ?: [];

$wrong = [];
if (count($eq)) {
  $qids = array_map(fn($r) => (string)$r['questionId'], $eq);
  $in = implode(',', array_fill(0, count($qids), '?'));

  $stmtQ = $pdo->prepare(
    'SELECT q.id, q.bank_id AS bankId, q.prompt, q.options, q.answer_index AS answerIndex, q.explanation AS explanationText
     FROM questions q
     WHERE q.id IN (' . $in . ')'
  );
  $stmtQ->execute($qids);
  $rows = $stmtQ->fetchAll() ?: [];
  $byId = [];
  foreach ($rows as $r) $byId[(string)$r['id']] = $r;

  $stmtA = $pdo->prepare('SELECT question_id AS questionId, bank_id AS bankId, selected_index AS selectedIndex, is_correct AS isCorrect, created_at
                          FROM user_question_attempts
                          WHERE user_id = :uid AND created_at >= :st AND created_at <= :en');
  $stmtA->execute([
    'uid' => $me['id'],
    'st' => (string)$session['started_at'],
    'en' => (string)$session['submitted_at'],
  ]);
  $attempts = $stmtA->fetchAll() ?: [];
  // pick latest attempt per question
  $aByQ = [];
  foreach ($attempts as $a) {
    $qid = (string)$a['questionId'];
    if (!isset($aByQ[$qid]) || (string)$a['created_at'] > (string)$aByQ[$qid]['created_at']) {
      $aByQ[$qid] = $a;
    }
  }

  foreach ($eq as $r) {
    $qid = (string)$r['questionId'];
    $qrow = $byId[$qid] ?? null;
    if (!$qrow) continue;
    $att = $aByQ[$qid] ?? null;
    if (!$att) continue;
    if ((int)($att['isCorrect'] ?? 0) === 1) continue;

    $wrong[] = [
      'questionId' => $qid,
      'bankId' => (string)($qrow['bankId'] ?? $r['bankId']),
      'prompt' => (string)$qrow['prompt'],
      'options' => json_decode((string)$qrow['options'], true) ?: [],
      'selectedIndex' => (int)($att['selectedIndex'] ?? -1),
      'answerIndex' => (int)($qrow['answerIndex'] ?? 0),
      'explain' => (string)($qrow['explanationText'] ?? ''),
    ];
  }
}

json_response([
  'success' => true,
  'data' => [
    'examId' => (string)$examId,
    'courseId' => $courseId,
    'total' => (int)($session['total_questions'] ?? 0),
    'correct' => (int)($session['correct_count'] ?? 0),
    'scorePercent' => (int)($session['score_percent'] ?? 0),
    'secondsTotal' => (int)($session['seconds_total'] ?? 0),
    'reviewWrong' => $wrong,
  ]
]);
