<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
$body = read_json();

$goal = isset($body['dailyGoal']) ? (int)$body['dailyGoal'] : 0;
if ($goal < 5) $goal = 5;
if ($goal > 200) $goal = 200;

// This endpoint is designed to be safe even if the gamification tables
// haven't been migrated yet.
try {
  $pdo->beginTransaction();

  $stmt = $pdo->prepare('SELECT user_id FROM user_gamification WHERE user_id = :uid LIMIT 1');
  $stmt->execute(['uid' => $me['id']]);
  $exists = (bool)$stmt->fetch();

  if ($exists) {
    $pdo->prepare('UPDATE user_gamification SET daily_goal = :g, updated_at = UTC_TIMESTAMP() WHERE user_id = :uid')
      ->execute(['g' => $goal, 'uid' => $me['id']]);
  } else {
    $pdo->prepare('INSERT INTO user_gamification (user_id, daily_goal, xp, level, badges_json, updated_at)
                   VALUES (:uid, :g, 0, 1, :b, UTC_TIMESTAMP())')
      ->execute([
        'uid' => $me['id'],
        'g'   => $goal,
        'b'   => json_encode([], JSON_UNESCAPED_UNICODE),
      ]);
  }

  $pdo->commit();

  json_response([
    'success' => true,
    'data' => [
      'dailyGoal' => $goal,
    ]
  ]);
} catch (Throwable $e) {
  if ($pdo->inTransaction()) $pdo->rollBack();
  // If table doesn't exist (migration not run), don't break the app.
  json_response([
    'success' => true,
    'data' => [
      'dailyGoal' => $goal,
      'warning' => 'Gamification tables not migrated yet.'
    ]
  ]);
}
