<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';
require_once __DIR__ . '/_missions.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);

try {
  $weekStart = missions_week_start_utc();
  $missions = missions_list($pdo, (string)$me['id'], $weekStart);
  $claimable = missions_claimable_count($pdo, (string)$me['id'], $weekStart);

  // streak freezes (best-effort)
  $streakFreezes = 0;
  try {
    $p = $pdo->prepare('SELECT streak_freezes FROM user_progress WHERE user_id = :uid LIMIT 1');
    $p->execute(['uid' => (string)$me['id']]);
    $streakFreezes = (int)(($p->fetch() ?: [])['streak_freezes'] ?? 0);
  } catch (Throwable $e) {
    $streakFreezes = 0;
  }

  json_response(['success' => true, 'data' => [
    'weekStart' => $weekStart,
    'missions' => $missions,
    'claimable' => $claimable,
    'streakFreezes' => $streakFreezes,
  ]]);

} catch (Throwable $e) {
  // Show the real error instead of masking it as "migration not applied"
  json_response([
    'success' => false,
    'error' => 'Server error',
    'detail' => $e->getMessage(),
    // Optional: remove these two lines after fixing
    'where' => basename((string)$e->getFile()) . ':' . (string)$e->getLine(),
  ], 500);
}
