<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require_once __DIR__ . '/../helpers.php';

function group_random_code(int $len = 6): string {
  $alphabet = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789'; // avoid confusing chars
  $out = '';
  for ($i = 0; $i < $len; $i++) {
    $out .= $alphabet[random_int(0, strlen($alphabet) - 1)];
  }
  return $out;
}

function group_require_member(PDO $pdo, string $groupId, string $userId): array {
  $stmt = $pdo->prepare('
    SELECT m.role, g.name, g.join_code AS joinCode, g.created_by AS createdBy
    FROM study_group_members m
    JOIN study_groups g ON g.id = m.group_id AND g.is_active = 1
    WHERE m.group_id = :gid AND m.user_id = :uid
    LIMIT 1
  ');
  $stmt->execute([':gid' => $groupId, ':uid' => $userId]);
  $row = $stmt->fetch();
  if (!$row) json_response(['success' => false, 'error' => 'Not a member of this group'], 403);
  return $row ?: [];
}

function group_require_owner(PDO $pdo, string $groupId, array $me): void {
  $row = group_require_member($pdo, $groupId, (string)$me['id']);
  $isOwner = ((string)($row['role'] ?? 'member')) === 'owner';
  if ($isOwner) return;
  if ((string)($me['role'] ?? '') === 'admin') return;
  json_response(['success' => false, 'error' => 'Group owner only'], 403);
}

function challenge_require_access(PDO $pdo, string $challengeId, string $userId): array {
  // Ensure challenge exists + user is a member of its group
  $stmt = $pdo->prepare('
    SELECT c.*, g.name AS groupName
    FROM study_group_challenges c
    JOIN study_groups g ON g.id = c.group_id AND g.is_active = 1
    JOIN study_group_members m ON m.group_id = c.group_id AND m.user_id = :uid
    WHERE c.id = :cid AND c.is_active = 1
    LIMIT 1
  ');
  $stmt->execute([':cid' => $challengeId, ':uid' => $userId]);
  $row = $stmt->fetch();
  if (!$row) json_response(['success' => false, 'error' => 'Challenge not found or access denied'], 404);
  return $row ?: [];
}
