<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}
$me = require_auth($pdo);

$sql = '
  SELECT COUNT(*) AS pending
  FROM study_group_members m
  JOIN study_group_challenges c ON c.group_id = m.group_id AND c.is_active = 1
  LEFT JOIN study_group_challenge_attempts a ON a.challenge_id = c.id AND a.user_id = m.user_id
  WHERE m.user_id = :uid AND a.id IS NULL
';
$stmt = $pdo->prepare($sql);
$stmt->execute([':uid' => $me['id']]);
$pending = (int)($stmt->fetchColumn() ?: 0);

json_response(['success' => true, 'data' => ['pending' => $pending]]);
