<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';
require_once __DIR__ . '/_helpers.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}
$me = require_auth($pdo);
$groupId = trim((string)($_GET['groupId'] ?? ''));
if ($groupId === '') json_response(['success' => false, 'error' => 'Missing groupId'], 422);

group_require_member($pdo, $groupId, (string)$me['id']);

$sql = '
  SELECT
    c.id,
    c.title,
    c.course_id AS courseId,
    c.total_questions AS total,
    c.duration_minutes AS durationMins,
    c.created_by AS createdBy,
    c.created_at AS createdAt,
    crs.code AS courseCode,
    crs.title AS courseTitle,
    a.id AS attemptId,
    a.score_percent AS myScore,
    a.seconds_total AS mySeconds,
    a.submitted_at AS mySubmittedAt
  FROM study_group_challenges c
  LEFT JOIN courses crs ON crs.id = c.course_id
  LEFT JOIN study_group_challenge_attempts a
    ON a.challenge_id = c.id AND a.user_id = :uid
  WHERE c.group_id = :gid AND c.is_active = 1
  ORDER BY c.created_at DESC
';
$stmt = $pdo->prepare($sql);
$stmt->execute([':gid' => $groupId, ':uid' => $me['id']]);
$rows = $stmt->fetchAll() ?: [];

$list = array_map(function($r){
  return [
    'id' => (string)$r['id'],
    'title' => (string)$r['title'],
    'courseId' => (string)$r['courseId'],
    'courseCode' => (string)($r['courseCode'] ?? ''),
    'courseTitle' => (string)($r['courseTitle'] ?? ''),
    'total' => (int)$r['total'],
    'durationMins' => (int)$r['durationMins'],
    'createdBy' => (string)$r['createdBy'],
    'createdAt' => (string)$r['createdAt'],
    'attempted' => $r['attemptId'] !== null,
    'myScore' => $r['myScore'] !== null ? (int)$r['myScore'] : null,
    'mySeconds' => $r['mySeconds'] !== null ? (int)$r['mySeconds'] : null,
    'mySubmittedAt' => $r['mySubmittedAt'] !== null ? (string)$r['mySubmittedAt'] : null,
  ];
}, $rows);

json_response(['success' => true, 'data' => ['challenges' => $list]]);
