<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';
require_once __DIR__ . '/_helpers.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}
$me = require_auth($pdo);
$body = read_json();
require_fields($body, ['name']);
$name = trim((string)$body['name']);
if ($name === '') json_response(['success' => false, 'error' => 'Invalid name'], 422);

$groupId = uuidv4();
$joinCode = group_random_code(6);

// Ensure join code unique (few retries)
for ($i = 0; $i < 6; $i++) {
  try {
    $pdo->beginTransaction();

    $pdo->prepare('INSERT INTO study_groups (id, name, join_code, created_by, created_at) VALUES (:id, :n, :c, :uid, UTC_TIMESTAMP())')
      ->execute([':id' => $groupId, ':n' => $name, ':c' => $joinCode, ':uid' => $me['id']]);

    $pdo->prepare('INSERT INTO study_group_members (group_id, user_id, role, joined_at) VALUES (:gid, :uid, "owner", UTC_TIMESTAMP())')
      ->execute([':gid' => $groupId, ':uid' => $me['id']]);

    $pdo->commit();
    break;
  } catch (Throwable $e) {
    if ($pdo->inTransaction()) $pdo->rollBack();
    // duplicate join code -> retry
    $joinCode = group_random_code(6);
    if ($i === 5) json_response(['success' => false, 'error' => 'Failed to create group'], 500);
  }
}

json_response([
  'success' => true,
  'data' => [
    'group' => [
      'id' => $groupId,
      'name' => $name,
      'joinCode' => $joinCode,
      'myRole' => 'owner',
    ]
  ]
]);
