<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';
require_once __DIR__ . '/_helpers.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}
$me = require_auth($pdo);
$groupId = trim((string)($_GET['groupId'] ?? ''));
if ($groupId === '') json_response(['success' => false, 'error' => 'Missing groupId'], 422);

$info = group_require_member($pdo, $groupId, (string)$me['id']);

$g = $pdo->prepare('SELECT id, name, join_code AS joinCode, created_by AS createdBy, created_at AS createdAt FROM study_groups WHERE id = :id AND is_active = 1 LIMIT 1');
$g->execute([':id' => $groupId]);
$row = $g->fetch();
if (!$row) json_response(['success' => false, 'error' => 'Group not found'], 404);

// members
$m = $pdo->prepare('
  SELECT u.id, u.full_name AS fullName, u.role, gm.role AS groupRole, gm.joined_at AS joinedAt
  FROM study_group_members gm
  JOIN users u ON u.id = gm.user_id
  WHERE gm.group_id = :gid
  ORDER BY (gm.role = "owner") DESC, gm.joined_at ASC
');
$m->execute([':gid' => $groupId]);
$members = $m->fetchAll() ?: [];

json_response([
  'success' => true,
  'data' => [
    'group' => [
      'id' => (string)$row['id'],
      'name' => (string)$row['name'],
      'joinCode' => (string)$row['joinCode'],
      'createdBy' => (string)$row['createdBy'],
      'createdAt' => (string)$row['createdAt'],
      'myRole' => (string)($info['role'] ?? 'member'),
    ],
    'members' => array_map(function($r){
      return [
        'id' => (string)$r['id'],
        'fullName' => (string)$r['fullName'],
        'role' => (string)$r['role'],
        'groupRole' => (string)$r['groupRole'],
        'joinedAt' => (string)$r['joinedAt'],
      ];
    }, $members),
  ]
]);
