<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}
$me = require_auth($pdo);
$body = read_json();
require_fields($body, ['code']);
$code = strtoupper(trim((string)$body['code']));
if ($code === '') json_response(['success' => false, 'error' => 'Invalid code'], 422);

$stmt = $pdo->prepare('SELECT id, name, join_code AS joinCode FROM study_groups WHERE join_code = :c AND is_active = 1 LIMIT 1');
$stmt->execute([':c' => $code]);
$g = $stmt->fetch();
if (!$g) json_response(['success' => false, 'error' => 'Group code not found'], 404);

$gid = (string)$g['id'];

$pdo->prepare('INSERT IGNORE INTO study_group_members (group_id, user_id, role, joined_at) VALUES (:gid, :uid, "member", UTC_TIMESTAMP())')
  ->execute([':gid' => $gid, ':uid' => $me['id']]);

json_response([
  'success' => true,
  'data' => [
    'group' => [
      'id' => $gid,
      'name' => (string)$g['name'],
      'joinCode' => (string)$g['joinCode'],
      'myRole' => 'member',
    ]
  ]
]);
