<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';
require_once __DIR__ . '/_helpers.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}
$me = require_auth($pdo);
$body = read_json();
require_fields($body, ['groupId']);
$groupId = trim((string)$body['groupId']);
if ($groupId === '') json_response(['success' => false, 'error' => 'Invalid groupId'], 422);

$info = group_require_member($pdo, $groupId, (string)$me['id']);
if ((string)($info['role'] ?? '') === 'owner') {
  json_response(['success' => false, 'error' => 'Owner cannot leave. Transfer ownership or delete group (admin).'], 409);
}

$pdo->prepare('DELETE FROM study_group_members WHERE group_id = :gid AND user_id = :uid')
  ->execute([':gid' => $groupId, ':uid' => $me['id']]);

json_response(['success' => true]);
