<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}
$me = require_auth($pdo);

$sql = '
  SELECT
    g.id,
    g.name,
    g.join_code AS joinCode,
    m.role AS myRole,
    g.created_at AS createdAt,
    (SELECT COUNT(*) FROM study_group_members mm WHERE mm.group_id = g.id) AS membersCount,
    (
      SELECT COUNT(*)
      FROM study_group_challenges c
      LEFT JOIN study_group_challenge_attempts a
        ON a.challenge_id = c.id AND a.user_id = :uid_attempt
      WHERE c.group_id = g.id AND c.is_active = 1 AND a.id IS NULL
    ) AS pendingChallenges
  FROM study_group_members m
  JOIN study_groups g ON g.id = m.group_id AND g.is_active = 1
  WHERE m.user_id = :uid_member
  ORDER BY g.created_at DESC
';
$stmt = $pdo->prepare($sql);
$stmt->execute([
  ':uid_attempt' => $me['id'],
  ':uid_member' => $me['id'],
]);
$rows = $stmt->fetchAll() ?: [];

$groups = array_map(function($r) {
  return [
    'id' => (string)$r['id'],
    'name' => (string)$r['name'],
    'joinCode' => (string)$r['joinCode'],
    'myRole' => (string)$r['myRole'],
    'createdAt' => (string)$r['createdAt'],
    'membersCount' => (int)($r['membersCount'] ?? 0),
    'pendingChallenges' => (int)($r['pendingChallenges'] ?? 0),
  ];
}, $rows);

json_response(['success' => true, 'data' => ['groups' => $groups]]);
