<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'DELETE') json_response(['success'=>false,'error'=>'Method not allowed'],405);

$me = require_auth($pdo);

$id = (string)($_GET['id'] ?? '');
if ($id === '') json_response(['success'=>false,'error'=>'Missing id'],422);

$stmt = $pdo->prepare('SELECT id, course_id, file_path, created_by FROM materials WHERE id = :id LIMIT 1');
$stmt->execute([':id'=>$id]);
$row = $stmt->fetch();
if (!$row) json_response(['success'=>false,'error'=>'Not found'],404);

$role = (string)($me['role'] ?? 'student');
if ($role !== 'admin') {
  // course reps can delete only their own uploads (and only within their assigned scope)
  if ($role !== 'course_rep' || (string)$row['created_by'] !== (string)$me['id']) {
    json_response(['success' => false, 'error' => 'Forbidden'], 403);
  }
  require_uploader($pdo, $me, (string)$row['course_id']);
}

$pdo->prepare('DELETE FROM materials WHERE id = :id')->execute([':id'=>$id]);

$fp = (string)$row['file_path'];
$abs = __DIR__ . '/..' . $fp;
if (is_file($abs)) @unlink($abs);

// audit (best-effort)
upload_audit_log($pdo, [
  'action' => 'delete',
  'entityType' => 'material',
  'entityId' => (string)$row['id'],
  'courseId' => (string)$row['course_id'],
  'filePath' => $fp,
  'actorId' => (string)$me['id'],
  'targetUserId' => (string)$row['created_by'],
  'details' => ['byRole' => $role]
]);

json_response(['success'=>true,'data'=>['deleted'=>true]]);
