-- JabuSpark migration: Course Rep approval system
-- Date: 2025-12-25

-- 1) Add course_rep to users.role
ALTER TABLE users MODIFY role ENUM('student','course_rep','admin') NOT NULL DEFAULT 'student';

-- 2) Requests table
CREATE TABLE IF NOT EXISTS course_rep_requests (
  id CHAR(36) NOT NULL,
  user_id CHAR(36) NOT NULL,
  level INT NULL,
  reason TEXT NOT NULL,
  proof_url VARCHAR(255) NULL,
  status ENUM('pending','approved','denied') NOT NULL DEFAULT 'pending',
  requested_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  reviewed_at DATETIME NULL,
  reviewed_by CHAR(36) NULL,
  admin_note TEXT NULL,
  PRIMARY KEY (id),
  INDEX idx_course_rep_requests_user (user_id),
  INDEX idx_course_rep_requests_status (status),
  INDEX idx_course_rep_requests_requested_at (requested_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- 3) Requested courses per request
CREATE TABLE IF NOT EXISTS course_rep_request_courses (
  request_id CHAR(36) NOT NULL,
  course_id VARCHAR(24) NOT NULL,
  PRIMARY KEY (request_id, course_id),
  INDEX idx_course_rep_request_courses_course (course_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- 4) Approved upload permissions
CREATE TABLE IF NOT EXISTS course_rep_courses (
  user_id CHAR(36) NOT NULL,
  course_id VARCHAR(24) NOT NULL,
  assigned_by CHAR(36) NULL,
  assigned_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (user_id, course_id),
  INDEX idx_course_rep_courses_course (course_id)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
