-- AI tables for Gemini integration

CREATE TABLE IF NOT EXISTS `ai_mcq_explanations` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `bank_id` varchar(64) NOT NULL,
  `question_id` varchar(64) NOT NULL,
  `mode` enum('hint','full') NOT NULL,
  `model` varchar(64) DEFAULT NULL,
  `prompt_hash` char(64) NOT NULL,
  `response_text` mediumtext NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_ai_mcq_qid_mode` (`question_id`, `mode`),
  UNIQUE KEY `uniq_ai_mcq_cache` (`question_id`, `mode`, `prompt_hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `ai_request_log` (
  `id` bigint(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  `user_id` char(36) NOT NULL,
  `kind` varchar(64) NOT NULL,
  `prompt_hash` char(64) NOT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_ai_req_user_kind_date` (`user_id`, `kind`, `created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
