-- Duel winner bonus metadata
-- Adds winner_user_id and bonus_awarded columns safely (works on MySQL/MariaDB)

SET @db := DATABASE();

-- Add winner_user_id if missing
SET @sql := (
  SELECT IF(
    COUNT(*) = 0,
    'ALTER TABLE duel_links ADD COLUMN winner_user_id CHAR(36) NULL AFTER completed_at',
    'SELECT 1'
  )
  FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = @db
    AND TABLE_NAME = 'duel_links'
    AND COLUMN_NAME = 'winner_user_id'
);
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Add bonus_awarded if missing
SET @sql := (
  SELECT IF(
    COUNT(*) = 0,
    'ALTER TABLE duel_links ADD COLUMN bonus_awarded TINYINT(1) NOT NULL DEFAULT 0 AFTER winner_user_id',
    'SELECT 1'
  )
  FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = @db
    AND TABLE_NAME = 'duel_links'
    AND COLUMN_NAME = 'bonus_awarded'
);
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- Helpful index (optional)
SET @sql := (
  SELECT IF(
    COUNT(*) = 0,
    'CREATE INDEX idx_duel_winner ON duel_links (winner_user_id)',
    'SELECT 1'
  )
  FROM INFORMATION_SCHEMA.STATISTICS
  WHERE TABLE_SCHEMA = @db
    AND TABLE_NAME = 'duel_links'
    AND INDEX_NAME = 'idx_duel_winner'
);
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
