-- 1v1 Duel (shareable challenge links)

CREATE TABLE IF NOT EXISTS `duel_links` (
  `id` varchar(64) NOT NULL,
  `code` varchar(16) NOT NULL,
  `bank_id` varchar(64) NOT NULL,
  `created_by` char(36) NOT NULL,
  `status` varchar(16) NOT NULL DEFAULT 'waiting',
  `question_count` int(11) NOT NULL DEFAULT 10,
  `duration_minutes` int(11) NOT NULL DEFAULT 10,
  `started_at` datetime DEFAULT NULL,
  `completed_at` datetime DEFAULT NULL,
  `expires_at` datetime DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_duel_code` (`code`),
  KEY `idx_duel_bank` (`bank_id`),
  KEY `idx_duel_created_by` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `duel_participants` (
  `duel_id` varchar(64) NOT NULL,
  `user_id` char(36) NOT NULL,
  `slot` int(11) NOT NULL,
  `joined_at` datetime NOT NULL DEFAULT current_timestamp(),
  `score` int(11) DEFAULT NULL,
  `seconds_total` int(11) DEFAULT NULL,
  `submitted_at` datetime DEFAULT NULL,
  PRIMARY KEY (`duel_id`, `user_id`),
  UNIQUE KEY `uq_duel_slot` (`duel_id`, `slot`),
  KEY `idx_duel_user` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `duel_link_questions` (
  `duel_id` varchar(64) NOT NULL,
  `position` int(11) NOT NULL,
  `question_id` varchar(64) NOT NULL,
  PRIMARY KEY (`duel_id`, `position`),
  KEY `idx_duel_q` (`question_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `duel_attempts` (
  `id` char(36) NOT NULL,
  `duel_id` varchar(64) NOT NULL,
  `user_id` char(36) NOT NULL,
  `answers_json` text NOT NULL,
  `correct_count` int(11) NOT NULL DEFAULT 0,
  `total_count` int(11) NOT NULL DEFAULT 0,
  `seconds_total` int(11) NOT NULL DEFAULT 0,
  `created_at` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `idx_duel_attempt_duel` (`duel_id`),
  KEY `idx_duel_attempt_user` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
