-- Weekly Missions + Streak Freeze migration (idempotent-ish)
-- Adds: user_progress.streak_freezes
-- Creates/Repairs: weekly_missions
-- NOTE: user IDs in this project are UUIDs stored as CHAR(36).

-- 1) Add streak_freezes column if missing
SET @col_exists := (
  SELECT COUNT(*)
  FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE()
    AND TABLE_NAME = 'user_progress'
    AND COLUMN_NAME = 'streak_freezes'
);

SET @sql_stmt := IF(
  @col_exists = 0,
  'ALTER TABLE user_progress ADD COLUMN streak_freezes INT NOT NULL DEFAULT 0',
  'SELECT 1'
);

PREPARE stmt FROM @sql_stmt;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- 2) Create weekly_missions table (correct UUID schema)
CREATE TABLE IF NOT EXISTS weekly_missions (
  id INT UNSIGNED NOT NULL AUTO_INCREMENT,
  user_id CHAR(36) NOT NULL,
  week_start DATE NOT NULL,
  mission_key VARCHAR(64) NOT NULL,
  title VARCHAR(160) NOT NULL,
  description VARCHAR(255) DEFAULT NULL,
  progress INT NOT NULL DEFAULT 0,
  goal INT NOT NULL,
  reward_xp INT NOT NULL DEFAULT 0,
  reward_freezes INT NOT NULL DEFAULT 0,
  completed_at DATETIME DEFAULT NULL,
  claimed_at DATETIME DEFAULT NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  updated_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  UNIQUE KEY uniq_user_week_mission (user_id, week_start, mission_key),
  KEY idx_user_week (user_id, week_start),
  KEY idx_week (week_start)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- 3) If weekly_missions already existed with the WRONG type (user_id INT), fix it.
SET @tbl_exists := (
  SELECT COUNT(*)
  FROM INFORMATION_SCHEMA.TABLES
  WHERE TABLE_SCHEMA = DATABASE()
    AND TABLE_NAME = 'weekly_missions'
);

SET @uid_is_char := (
  SELECT COUNT(*)
  FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = DATABASE()
    AND TABLE_NAME = 'weekly_missions'
    AND COLUMN_NAME = 'user_id'
    AND COLUMN_TYPE LIKE 'char(36)%'
);

SET @sql_stmt := IF(
  @tbl_exists = 1 AND @uid_is_char = 0,
  'ALTER TABLE weekly_missions MODIFY user_id CHAR(36) NOT NULL',
  'SELECT 1'
);

PREPARE stmt FROM @sql_stmt;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- 4) Add FK weekly_missions.user_id -> users.id (if missing)
SET @fk_exists := (
  SELECT COUNT(*)
  FROM INFORMATION_SCHEMA.KEY_COLUMN_USAGE
  WHERE TABLE_SCHEMA = DATABASE()
    AND TABLE_NAME = 'weekly_missions'
    AND CONSTRAINT_NAME = 'fk_weekly_missions_user'
);

SET @sql_stmt := IF(
  @tbl_exists = 1 AND @fk_exists = 0,
  'ALTER TABLE weekly_missions ADD CONSTRAINT fk_weekly_missions_user FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE',
  'SELECT 1'
);

PREPARE stmt FROM @sql_stmt;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
