-- Department onboarding waitlist / requests
-- Run this once on your DB.

CREATE TABLE IF NOT EXISTS department_requests (
  id CHAR(36) NOT NULL,
  user_id CHAR(36) NOT NULL,
  faculty_id VARCHAR(64) NULL,
  department_id VARCHAR(64) NULL,
  department_name VARCHAR(255) NULL,
  level INT NULL,
  course_codes TEXT NULL,
  phone VARCHAR(32) NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  KEY idx_department_requests_user (user_id),
  KEY idx_department_requests_dept (department_id),
  KEY idx_department_requests_created (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
