-- Duel winner bonus awards (idempotent)
-- Creates duel_bonus_awards table and adds optional metadata columns on duel_links
-- Safe to run multiple times (MySQL/MariaDB)

SET @db := DATABASE();

-- 1) duel_bonus_awards table
CREATE TABLE IF NOT EXISTS `duel_bonus_awards` (
  `id` CHAR(36) NOT NULL,
  `duel_id` VARCHAR(64) NOT NULL,
  `winner_user_id` CHAR(36) NOT NULL,
  `bonus_xp` INT(11) NOT NULL DEFAULT 50,
  `awarded_at` DATETIME NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `uq_duel_bonus_duel` (`duel_id`),
  KEY `idx_duel_bonus_winner` (`winner_user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- 2) duel_links.winner_user_id
SET @sql := (
  SELECT IF(
    COUNT(*) = 0,
    'ALTER TABLE duel_links ADD COLUMN winner_user_id CHAR(36) NULL AFTER created_at',
    'SELECT 1'
  )
  FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = @db
    AND TABLE_NAME = 'duel_links'
    AND COLUMN_NAME = 'winner_user_id'
);
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- 3) duel_links.winner_bonus_xp (amount to award winner)
SET @sql := (
  SELECT IF(
    COUNT(*) = 0,
    'ALTER TABLE duel_links ADD COLUMN winner_bonus_xp INT(11) NOT NULL DEFAULT 50 AFTER winner_user_id',
    'SELECT 1'
  )
  FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = @db
    AND TABLE_NAME = 'duel_links'
    AND COLUMN_NAME = 'winner_bonus_xp'
);
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;

-- 4) duel_links.bonus_awarded_at (timestamp when bonus award was inserted)
SET @sql := (
  SELECT IF(
    COUNT(*) = 0,
    'ALTER TABLE duel_links ADD COLUMN bonus_awarded_at DATETIME NULL DEFAULT NULL AFTER winner_bonus_xp',
    'SELECT 1'
  )
  FROM INFORMATION_SCHEMA.COLUMNS
  WHERE TABLE_SCHEMA = @db
    AND TABLE_NAME = 'duel_links'
    AND COLUMN_NAME = 'bonus_awarded_at'
);
PREPARE stmt FROM @sql;
EXECUTE stmt;
DEALLOCATE PREPARE stmt;
