-- AI response cache (read-through cache for Gemini calls)
-- Date: 2026-01-08

CREATE TABLE IF NOT EXISTS ai_cache (
  cache_key CHAR(64) NOT NULL,
  purpose VARCHAR(50) NOT NULL,
  model VARCHAR(80) NOT NULL,
  response_json MEDIUMTEXT NOT NULL,
  hit_count INT NOT NULL DEFAULT 0,
  last_hit DATETIME NULL,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  expires_at DATETIME NULL,
  PRIMARY KEY (cache_key),
  KEY idx_ai_cache_purpose (purpose),
  KEY idx_ai_cache_expires (expires_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
