-- JabuStudyHub migration: Theory question system
-- Date: 2026-01-10

-- This migration introduces a theory-writing practice system.
-- It reuses the existing `banks` table; create theory banks with banks.mode = 'theory'.

-- 1) Theory questions
CREATE TABLE IF NOT EXISTS theory_questions (
  id VARCHAR(64) NOT NULL,
  bank_id VARCHAR(64) NOT NULL,
  prompt TEXT NOT NULL,
  guide TEXT NULL,
  points_json JSON NULL,
  sort_order INT NOT NULL DEFAULT 1,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  INDEX idx_theory_questions_bank (bank_id),
  INDEX idx_theory_questions_bank_sort (bank_id, sort_order)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- 2) User theory attempts
CREATE TABLE IF NOT EXISTS user_theory_attempts (
  id BIGINT(20) UNSIGNED NOT NULL AUTO_INCREMENT,
  user_id CHAR(36) NOT NULL,
  bank_id VARCHAR(64) NOT NULL,
  question_id VARCHAR(64) NOT NULL,
  answer_text TEXT NOT NULL,
  self_score TINYINT(3) UNSIGNED NULL,
  seconds_spent INT(11) NOT NULL DEFAULT 0,
  created_at DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (id),
  INDEX idx_user_theory_attempts_user (user_id),
  INDEX idx_user_theory_attempts_bank (bank_id),
  INDEX idx_user_theory_attempts_user_bank (user_id, bank_id),
  INDEX idx_user_theory_attempts_question (question_id),
  INDEX idx_user_theory_attempts_created (created_at)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

-- Optional safety: keep deletions fast
-- (No foreign keys are enforced because current schema does not use them consistently.)
