<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';
require_once __DIR__ . '/../helpers.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
$body = json_decode((string)file_get_contents('php://input'), true) ?: [];
require_fields($body, ['channelId']);

$channelId = trim((string)$body['channelId']);
// IMPORTANT:
// - If `follow` is omitted => toggle
// - If `follow` is explicitly true/false => set
// - If `follow` is present but null (common when client always sends the key) => treat as toggle
//   (because (bool)null becomes false and breaks toggling)
$follow = null;
if (array_key_exists('follow', $body) && $body['follow'] !== null) {
  $follow = (bool)$body['follow'];
}

// Validate channel exists
$stmt = $pdo->prepare('SELECT id FROM notify_channels WHERE id = :cid AND is_active = 1 LIMIT 1');
$stmt->execute([':cid' => $channelId]);
$exists = (bool)$stmt->fetchColumn();
if (!$exists) {
  json_response(['success' => false, 'error' => 'Channel not found'], 404);
}

// Determine current state
$stmt = $pdo->prepare('SELECT 1 FROM notify_channel_follows WHERE user_id = :uid AND channel_id = :cid LIMIT 1');
$stmt->execute([':uid' => $me['id'], ':cid' => $channelId]);
$has = (bool)$stmt->fetchColumn();

$want = $follow;
if ($want === null) $want = !$has; // toggle

if ($want && !$has) {
  $ins = $pdo->prepare('INSERT IGNORE INTO notify_channel_follows (user_id, channel_id) VALUES (:uid, :cid)');
  $ins->execute([':uid' => $me['id'], ':cid' => $channelId]);
}

if (!$want && $has) {
  $del = $pdo->prepare('DELETE FROM notify_channel_follows WHERE user_id = :uid AND channel_id = :cid');
  $del->execute([':uid' => $me['id'], ':cid' => $channelId]);
}

json_response([
  'success' => true,
  'data' => [
    'channelId' => $channelId,
    'isFollowed' => (bool)$want,
  ]
]);
