<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';
require_once __DIR__ . '/../helpers.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
require_admin($me);

$body = json_decode((string)file_get_contents('php://input'), true) ?: [];
require_fields($body, ['channelId', 'title', 'body']);

$channelId = trim((string)$body['channelId']);
$title = trim((string)$body['title']);
$text = trim((string)$body['body']);
$linkUrl = isset($body['linkUrl']) ? trim((string)$body['linkUrl']) : null;
$attachmentUrl = isset($body['attachmentUrl']) ? trim((string)$body['attachmentUrl']) : null;
$attachmentType = isset($body['attachmentType']) ? trim((string)$body['attachmentType']) : null;
$isPinned = !empty($body['isPinned']) ? 1 : 0;
$expiresAt = isset($body['expiresAt']) ? trim((string)$body['expiresAt']) : null;

// Validate channel
$stmt = $pdo->prepare('SELECT id FROM notify_channels WHERE id = :cid AND is_active = 1 LIMIT 1');
$stmt->execute([':cid' => $channelId]);
$exists = (bool)$stmt->fetchColumn();
if (!$exists) {
  json_response(['success' => false, 'error' => 'Channel not found'], 404);
}

$id = uuidv4();

$ins = $pdo->prepare('INSERT INTO notify_posts (id, channel_id, title, body, link_url, attachment_url, attachment_type, is_pinned, expires_at, created_by)
                      VALUES (:id, :chid, :t, :b, :l, :a, :at, :pin, :exp, :uid)');
$ins->execute([
  ':id' => $id,
  ':chid' => $channelId,
  ':t' => $title,
  ':b' => $text,
  ':l' => $linkUrl !== '' ? $linkUrl : null,
  ':a' => $attachmentUrl !== '' ? $attachmentUrl : null,
  ':at' => $attachmentType !== '' ? $attachmentType : null,
  ':pin' => $isPinned,
  ':exp' => $expiresAt !== '' ? $expiresAt : null,
  ':uid' => $me['id'],
]);

json_response([
  'success' => true,
  'data' => [
    'post' => [
      'id' => $id,
      'channelId' => $channelId,
      'title' => $title,
      'body' => $text,
      'isPinned' => $isPinned === 1,
      'createdAt' => gmdate('Y-m-d H:i:s'),
    ]
  ]
]);
