<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';
require_once __DIR__ . '/../helpers.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
$body = json_decode((string)file_get_contents('php://input'), true) ?: [];

// Two modes:
// 1) { postId }
// 2) { all: true, channelId? }

if (!empty($body['all'])) {
  $channelId = trim((string)($body['channelId'] ?? ''));

  if ($channelId !== '') {
    // Mark all in a channel as read
    $sql = '
      INSERT IGNORE INTO notify_post_reads (user_id, post_id)
      SELECT :uid, p.id
      FROM notify_posts p
      WHERE p.channel_id = :cid
    ';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([':uid' => $me['id'], ':cid' => $channelId]);
  } else {
    // Mark all from followed channels as read
    $sql = '
      INSERT IGNORE INTO notify_post_reads (user_id, post_id)
      SELECT :uid_insert, p.id
      FROM notify_channel_follows f
      JOIN notify_posts p ON p.channel_id = f.channel_id
      WHERE f.user_id = :uid_filter
    ';
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
      ':uid_insert' => $me['id'],
      ':uid_filter' => $me['id'],
    ]);
  }

  json_response(['success' => true, 'data' => ['ok' => true]]);
}

require_fields($body, ['postId']);
$postId = trim((string)$body['postId']);

// validate post exists
$stmt = $pdo->prepare('SELECT id FROM notify_posts WHERE id = :pid LIMIT 1');
$stmt->execute([':pid' => $postId]);
$exists = (bool)$stmt->fetchColumn();
if (!$exists) {
  json_response(['success' => false, 'error' => 'Post not found'], 404);
}

$ins = $pdo->prepare('INSERT IGNORE INTO notify_post_reads (user_id, post_id) VALUES (:uid, :pid)');
$ins->execute([':uid' => $me['id'], ':pid' => $postId]);

json_response(['success' => true, 'data' => ['ok' => true, 'postId' => $postId]]);
