<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
$body = read_json();

$facultyId = array_key_exists('facultyId', $body) ? trim((string)$body['facultyId']) : '';
$departmentId = array_key_exists('departmentId', $body) ? trim((string)$body['departmentId']) : '';
$departmentName = array_key_exists('departmentName', $body) ? trim((string)$body['departmentName']) : '';
$level = array_key_exists('level', $body) ? (int)$body['level'] : 0;
$courseCodes = array_key_exists('courseCodes', $body) ? trim((string)$body['courseCodes']) : '';
$phone = array_key_exists('phone', $body) ? trim((string)$body['phone']) : '';

if ($departmentId === '' && $departmentName === '') {
  json_response(['success' => false, 'error' => 'Choose a department (or type the department name).'], 422);
}

if ($level < 0) $level = 0;
if (strlen($courseCodes) > 2000) $courseCodes = substr($courseCodes, 0, 2000);
if (strlen($phone) > 32) $phone = substr($phone, 0, 32);

try {
  // Best-effort: create table might not exist yet if migration not run.
  $id = uuidv4();
  $stmt = $pdo->prepare('INSERT INTO department_requests (id, user_id, faculty_id, department_id, department_name, level, course_codes, phone)
                         VALUES (:id, :uid, :fid, :did, :dname, :lvl, :codes, :phone)');
  $stmt->execute([
    ':id' => $id,
    ':uid' => (string)$me['id'],
    ':fid' => ($facultyId !== '' ? $facultyId : null),
    ':did' => ($departmentId !== '' ? $departmentId : null),
    ':dname' => ($departmentName !== '' ? $departmentName : null),
    ':lvl' => ($level > 0 ? $level : null),
    ':codes' => ($courseCodes !== '' ? $courseCodes : null),
    ':phone' => ($phone !== '' ? $phone : null),
  ]);

  json_response(['success' => true, 'data' => ['id' => $id]]);
} catch (Throwable $e) {
  // If table doesn't exist, return a clear error for setup.
  $msg = (string)$e->getMessage();
  if (stripos($msg, 'department_requests') !== false) {
    json_response([
      'success' => false,
      'error' => 'Department requests is not available yet. Run the migration: api/migrations/2026_01_01_department_requests.sql'
    ], 400);
  }
  json_response(['success' => false, 'error' => 'Failed to submit request'], 500);
}
