<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'DELETE') json_response(['success'=>false,'error'=>'Method not allowed'],405);

$me = require_auth($pdo);

$id = (string)($_GET['id'] ?? '');
if ($id === '') json_response(['success'=>false,'error'=>'Missing id'],422);

$stmt = $pdo->prepare('SELECT id, course_id, file_path, created_by FROM past_questions WHERE id = :id LIMIT 1');
$stmt->execute([':id'=>$id]);
$row = $stmt->fetch();
if (!$row) json_response(['success'=>false,'error'=>'Not found'],404);

$role = (string)($me['role'] ?? 'student');
if ($role !== 'admin') {
  if ($role !== 'course_rep' || (string)$row['created_by'] !== (string)$me['id']) {
    json_response(['success' => false, 'error' => 'Forbidden'], 403);
  }
  require_uploader($pdo, $me, (string)$row['course_id']);
}

$pdo->prepare('DELETE FROM past_questions WHERE id = :id')->execute([':id'=>$id]);

$fp = (string)$row['file_path'];
$abs = __DIR__ . '/..' . $fp;
if (is_file($abs)) @unlink($abs);

upload_audit_log($pdo, [
  'action' => 'delete',
  'entityType' => 'past_question',
  'entityId' => (string)$row['id'],
  'courseId' => (string)$row['course_id'],
  'filePath' => $fp,
  'actorId' => (string)$me['id'],
  'targetUserId' => (string)$row['created_by'],
  'details' => ['byRole' => $role]
]);

json_response(['success'=>true,'data'=>['deleted'=>true]]);
