<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'PATCH') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
$body = read_json();
require_fields($body, ['id']);

$id = trim((string)($body['id'] ?? ''));
if ($id === '') {
  json_response(['success' => false, 'error' => 'Missing id'], 422);
}

$stmt = $pdo->prepare('SELECT id, course_id, title, session, semester, file_path, created_by FROM past_questions WHERE id = :id LIMIT 1');
$stmt->execute([':id' => $id]);
$row = $stmt->fetch();
if (!$row) {
  json_response(['success' => false, 'error' => 'Not found'], 404);
}

$role = (string)($me['role'] ?? 'student');
if ($role !== 'admin') {
  if ($role !== 'course_rep' || (string)$row['created_by'] !== (string)$me['id']) {
    json_response(['success' => false, 'error' => 'Forbidden'], 403);
  }
  require_uploader($pdo, $me, (string)$row['course_id']);
}

$updates = [];
$params = [':id' => $id];

if (array_key_exists('title', $body)) {
  $title = trim((string)($body['title'] ?? ''));
  if ($title === '') json_response(['success' => false, 'error' => 'title cannot be empty'], 422);
  $updates[] = 'title = :title';
  $params[':title'] = $title;
}

if (array_key_exists('session', $body)) {
  $session = trim((string)($body['session'] ?? ''));
  if ($session === '') $session = 'Unknown';
  $updates[] = 'session = :session';
  $params[':session'] = $session;
}

if (array_key_exists('semester', $body)) {
  $semester = trim((string)($body['semester'] ?? ''));
  if ($semester === '') $semester = 'Unknown';
  $updates[] = 'semester = :semester';
  $params[':semester'] = $semester;
}

if (count($updates) === 0) {
  json_response(['success' => false, 'error' => 'No fields to update'], 422);
}

$pdo->prepare('UPDATE past_questions SET ' . implode(', ', $updates) . ' WHERE id = :id')->execute($params);

$stmt = $pdo->prepare('SELECT id, course_id AS courseId, session, semester, title, file_path, uploaded_at AS uploadedAt, created_by AS createdBy
                        FROM past_questions WHERE id = :id LIMIT 1');
$stmt->execute([':id' => $id]);
$u = $stmt->fetch();

$item = $u ?: [];
$item['fileUrl'] = public_url((string)($item['file_path'] ?? ''));
unset($item['file_path']);

upload_audit_log($pdo, [
  'action' => 'update',
  'entityType' => 'past_question',
  'entityId' => $id,
  'courseId' => (string)$row['course_id'],
  'filePath' => (string)$row['file_path'],
  'actorId' => (string)$me['id'],
  'targetUserId' => (string)$row['created_by'],
  'details' => ['changed' => array_keys($params)],
]);

json_response(['success' => true, 'data' => ['pastQuestion' => $item]]);
