<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);

$courseId = (string)($_GET['courseId'] ?? '');
$limit = (int)($_GET['limit'] ?? 25);
if ($limit < 1) $limit = 25;
if ($limit > 100) $limit = 100;

try {
  $sql = '
    SELECT
      uwq.course_id AS courseId,
      uwq.bank_id AS bankId,
      uwq.question_id AS id,
      uwq.wrong_count AS wrongCount,
      uwq.next_review_at AS nextReviewAt,
      b.title AS bankTitle,
      c.code AS courseCode,
      c.title AS courseTitle,
      c.level AS courseLevel,
      q.prompt AS prompt,
      q.options AS options,
      q.answer_index AS answerIndex,
      q.explanation AS explanation
    FROM user_wrong_questions uwq
    JOIN questions q ON q.bank_id = uwq.bank_id AND q.id = uwq.question_id
    JOIN banks b ON b.id = uwq.bank_id
    JOIN courses c ON c.id = uwq.course_id
    WHERE uwq.user_id = :uid
      AND uwq.status = "active"
      AND uwq.next_review_at <= UTC_TIMESTAMP()
  ';
  $params = ['uid' => $me['id']];

  if ($courseId !== '') {
    $sql .= ' AND uwq.course_id = :cid ';
    $params['cid'] = $courseId;
  }

  $sql .= ' ORDER BY uwq.next_review_at ASC LIMIT :lim';

  $st = $pdo->prepare($sql);
  foreach ($params as $k => $v) $st->bindValue(':' . $k, $v);
  $st->bindValue(':lim', $limit, PDO::PARAM_INT);
  $st->execute();

  $rows = $st->fetchAll() ?: [];

  $questions = array_map(static function ($r) {
    $opts = json_decode((string)($r['options'] ?? '[]'), true);
    if (!is_array($opts)) $opts = [];
    return [
      'courseId' => (string)$r['courseId'],
      'courseCode' => (string)$r['courseCode'],
      'courseTitle' => (string)$r['courseTitle'],
      'courseLevel' => (int)($r['courseLevel'] ?? 0),
      'bankId' => (string)$r['bankId'],
      'bankTitle' => (string)$r['bankTitle'],
      'id' => (string)$r['id'],
      'prompt' => (string)$r['prompt'],
      'options' => $opts,
      'answerIndex' => (int)($r['answerIndex'] ?? 0),
      'explanation' => $r['explanation'] === null ? null : (string)$r['explanation'],
      'wrongCount' => (int)($r['wrongCount'] ?? 0),
      'nextReviewAt' => (string)($r['nextReviewAt'] ?? ''),
    ];
  }, $rows);

  json_response(['success' => true, 'data' => ['questions' => $questions]]);
} catch (Throwable $e) {
  json_response(['success' => false, 'error' => 'Failed to load review queue'], 500);
}
