<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);

try {
  // Base: courses user has selected (from onboarding)
  $c = $pdo->prepare('
    SELECT c.id, c.code, c.title, c.level
    FROM user_courses uc
    JOIN courses c ON c.id = uc.course_id
    WHERE uc.user_id = :uid
    ORDER BY c.level ASC, c.code ASC
  ');
  $c->execute(['uid' => $me['id']]);
  $courses = $c->fetchAll() ?: [];

  // Attempts summary by course (last attempt, time spent, accuracy)
  $a = $pdo->prepare('
    SELECT b.course_id AS courseId,
           COUNT(*) AS attempts,
           SUM(a.is_correct) AS correct,
           SUM(a.seconds_spent) AS seconds,
           MAX(a.created_at) AS lastAttemptAt
    FROM user_question_attempts a
    JOIN banks b ON b.id = a.bank_id
    WHERE a.user_id = :uid
    GROUP BY b.course_id
  ');
  $a->execute(['uid' => $me['id']]);
  $attempts = [];
  foreach ($a->fetchAll() ?: [] as $r) {
    $attempts[(string)$r['courseId']] = [
      'attempts' => (int)($r['attempts'] ?? 0),
      'correct' => (int)($r['correct'] ?? 0),
      'seconds' => (int)($r['seconds'] ?? 0),
      'lastAttemptAt' => $r['lastAttemptAt'] === null ? null : (string)$r['lastAttemptAt'],
    ];
  }

  // Due reviews by course
  $d = $pdo->prepare('
    SELECT course_id AS courseId, COUNT(*) AS due
    FROM user_wrong_questions
    WHERE user_id = :uid AND status = "active" AND next_review_at <= UTC_TIMESTAMP()
    GROUP BY course_id
  ');
  $d->execute(['uid' => $me['id']]);
  $due = [];
  foreach ($d->fetchAll() ?: [] as $r) {
    $due[(string)$r['courseId']] = (int)($r['due'] ?? 0);
  }

  $out = array_map(static function ($c) use ($attempts, $due) {
    $cid = (string)$c['id'];
    $a = $attempts[$cid] ?? ['attempts'=>0,'correct'=>0,'seconds'=>0,'lastAttemptAt'=>null];
    $acc = $a['attempts'] ? (int)round(($a['correct'] / $a['attempts']) * 100) : 0;
    return [
      'courseId' => $cid,
      'code' => (string)$c['code'],
      'title' => (string)$c['title'],
      'level' => (int)($c['level'] ?? 0),
      'attempts' => (int)$a['attempts'],
      'correct' => (int)$a['correct'],
      'accuracy' => $acc,
      'studySeconds' => (int)$a['seconds'],
      'lastAttemptAt' => $a['lastAttemptAt'],
      'dueReviews' => (int)($due[$cid] ?? 0),
    ];
  }, $courses);

  json_response(['success'=>true, 'data'=>['courses'=>$out]]);
} catch (Throwable $e) {
  json_response(['success'=>false, 'error'=>'Failed to load course progress'], 500);
}
