<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);

$courseId = (string)($_GET['courseId'] ?? '');
$days = (int)($_GET['days'] ?? 14);
if ($days < 7) $days = 7;
if ($days > 60) $days = 60;

try {
  if ($courseId === '') {
    json_response(['success'=>false, 'error'=>'Missing courseId'], 422);
  }

  $st = $pdo->prepare('
    SELECT
      DATE(a.created_at) AS d,
      COUNT(*) AS attempts,
      SUM(a.is_correct) AS correct
    FROM user_question_attempts a
    JOIN banks b ON b.id = a.bank_id
    WHERE a.user_id = :uid
      AND b.course_id = :cid
      AND a.created_at >= DATE_SUB(UTC_TIMESTAMP(), INTERVAL :days DAY)
    GROUP BY DATE(a.created_at)
    ORDER BY d ASC
  ');
  $st->bindValue(':uid', $me['id']);
  $st->bindValue(':cid', $courseId);
  $st->bindValue(':days', $days, PDO::PARAM_INT);
  $st->execute();

  $rows = $st->fetchAll() ?: [];
  $points = array_map(static function ($r) {
    $attempts = (int)($r['attempts'] ?? 0);
    $correct = (int)($r['correct'] ?? 0);
    $acc = $attempts ? (int)round(($correct / $attempts) * 100) : 0;
    return [
      'date' => (string)$r['d'],
      'attempts' => $attempts,
      'accuracy' => $acc,
    ];
  }, $rows);

  json_response(['success'=>true, 'data'=>['courseId'=>$courseId,'days'=>$days,'points'=>$points]]);
} catch (Throwable $e) {
  json_response(['success'=>false, 'error'=>'Failed to load trend'], 500);
}
