<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);

$stmt = $pdo->prepare('SELECT id, status, level, reason, proof_url, requested_at, reviewed_at, reviewed_by, admin_note
                       FROM course_rep_requests
                       WHERE user_id = :uid
                       ORDER BY requested_at DESC
                       LIMIT 1');
$stmt->execute([':uid' => $me['id']]);
$r = $stmt->fetch();

if (!$r) {
  json_response(['success' => true, 'data' => ['request' => null]]);
}

$stmt = $pdo->prepare('SELECT course_id FROM course_rep_request_courses WHERE request_id = :rid');
$stmt->execute([':rid' => $r['id']]);
$courseIds = array_values(array_map(fn($x) => $x['course_id'], $stmt->fetchAll() ?: []));

json_response(['success' => true, 'data' => ['request' => [
  'id' => $r['id'],
  'status' => $r['status'],
  'level' => $r['level'] !== null ? (int)$r['level'] : null,
  'reason' => $r['reason'],
  'proofUrl' => $r['proof_url'],
  'courseIds' => $courseIds,
  'requestedAt' => $r['requested_at'],
  'reviewedAt' => $r['reviewed_at'],
  'adminNote' => $r['admin_note'],
]]]);
