<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);

$courseId = trim((string)($_GET['courseId'] ?? ''));
$limit = max(1, min(200, (int)($_GET['limit'] ?? 100)));
$offset = max(0, (int)($_GET['offset'] ?? 0));

$where = 's.user_id = :uid AND s.kind = "pastQuestions"';
$params = [':uid' => (string)$me['id']];
if ($courseId !== '') {
  $where .= ' AND pq.course_id = :cid';
  $params[':cid'] = $courseId;
}

// Total
$total = 0;
try {
  $stmt = $pdo->prepare(
    'SELECT COUNT(*)
     FROM saved_items s
     JOIN past_questions pq ON pq.id = s.item_id
     WHERE ' . $where
  );
  $stmt->execute($params);
  $total = (int)$stmt->fetchColumn();
} catch (Throwable $e) {
  $total = 0;
}

$sql =
  'SELECT
      pq.id,
      pq.course_id AS courseId,
      pq.session,
      pq.semester,
      pq.title,
      pq.file_path,
      pq.uploaded_at AS uploadedAt,
      pq.created_by AS createdBy,
      s.created_at AS savedAt
    FROM saved_items s
    JOIN past_questions pq ON pq.id = s.item_id
    WHERE ' . $where . '
    ORDER BY s.created_at DESC
    LIMIT :limit OFFSET :offset';

$stmt = $pdo->prepare($sql);

// Bind standard params
$stmt->bindValue(':uid', (string)$me['id'], PDO::PARAM_STR);
if ($courseId !== '') {
  $stmt->bindValue(':cid', $courseId, PDO::PARAM_STR);
}
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);

$stmt->execute();
$rows = $stmt->fetchAll() ?: [];

$items = array_map(function ($r) {
  return [
    'id' => (string)$r['id'],
    'courseId' => (string)$r['courseId'],
    'session' => (string)($r['session'] ?? ''),
    'semester' => (string)($r['semester'] ?? ''),
    'title' => (string)($r['title'] ?? ''),
    'uploadedAt' => (string)($r['uploadedAt'] ?? ''),
    'createdBy' => $r['createdBy'] !== null ? (string)$r['createdBy'] : null,
    'savedAt' => (string)($r['savedAt'] ?? ''),
    'fileUrl' => public_url((string)($r['file_path'] ?? '')),
  ];
}, $rows);

json_response([
  'success' => true,
  'data' => [
    'items' => $items,
    'total' => $total,
    'limit' => $limit,
    'offset' => $offset,
  ],
]);
