<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);

$courseId = trim((string)($_GET['courseId'] ?? ''));
$limit = max(1, min(200, (int)($_GET['limit'] ?? 50)));
$offset = max(0, (int)($_GET['offset'] ?? 0));

$where = 's.user_id = :uid AND s.kind = "questions"';
$params = [':uid' => (string)$me['id']];
if ($courseId !== '') {
  $where .= ' AND b.course_id = :cid';
  $params[':cid'] = $courseId;
}

// Total
$total = 0;
try {
  $stmt = $pdo->prepare(
    'SELECT COUNT(*)
     FROM saved_items s
     JOIN questions q ON q.id = s.item_id
     JOIN banks b ON b.id = q.bank_id
     WHERE ' . $where
  );
  $stmt->execute($params);
  $total = (int)$stmt->fetchColumn();
} catch (Throwable $e) {
  $total = 0;
}

$sql =
  'SELECT
      s.item_id AS id,
      s.created_at AS savedAt,
      q.bank_id AS bankId,
      q.prompt AS prompt,
      q.`options` AS options,
      q.answer_index AS answerIndex,
      q.explanation AS explanation,
      b.title AS bankTitle,
      b.mode AS bankMode,
      b.course_id AS courseId,
      c.code AS courseCode,
      c.title AS courseTitle,
      c.level AS courseLevel
    FROM saved_items s
    JOIN questions q ON q.id = s.item_id
    JOIN banks b ON b.id = q.bank_id
    LEFT JOIN courses c ON c.id = b.course_id
    WHERE ' . $where . '
    ORDER BY s.created_at DESC
    LIMIT :limit OFFSET :offset';

$stmt = $pdo->prepare($sql);
$stmt->bindValue(':uid', (string)$me['id'], PDO::PARAM_STR);
if ($courseId !== '') {
  $stmt->bindValue(':cid', $courseId, PDO::PARAM_STR);
}
$stmt->bindValue(':limit', $limit, PDO::PARAM_INT);
$stmt->bindValue(':offset', $offset, PDO::PARAM_INT);
$stmt->execute();
$rows = $stmt->fetchAll() ?: [];

$items = array_map(static function ($r) {
  $opts = json_decode((string)($r['options'] ?? '[]'), true);
  if (!is_array($opts)) $opts = [];

  return [
    'id' => (string)($r['id'] ?? ''),
    'savedAt' => (string)($r['savedAt'] ?? ''),
    'bankId' => (string)($r['bankId'] ?? ''),
    'bankTitle' => (string)($r['bankTitle'] ?? ''),
    'bankMode' => $r['bankMode'] !== null ? (string)$r['bankMode'] : null,
    'courseId' => (string)($r['courseId'] ?? ''),
    'courseCode' => $r['courseCode'] !== null ? (string)$r['courseCode'] : null,
    'courseTitle' => $r['courseTitle'] !== null ? (string)$r['courseTitle'] : null,
    'courseLevel' => $r['courseLevel'] !== null ? (int)$r['courseLevel'] : null,
    'prompt' => (string)($r['prompt'] ?? ''),
    'options' => $opts,
    'answerIndex' => (int)($r['answerIndex'] ?? 0),
    'explanation' => $r['explanation'] === null ? null : (string)$r['explanation'],
  ];
}, $rows);

json_response([
  'success' => true,
  'data' => [
    'items' => $items,
    'total' => $total,
    'limit' => $limit,
    'offset' => $offset,
  ],
]);
