<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'POST') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
$body = read_json();
require_fields($body, ['bankId']);

$bankId = trim((string)($body['bankId'] ?? ''));
if ($bankId === '') {
  json_response(['success' => false, 'error' => 'Missing bankId'], 422);
}

try {
  $stmt = $pdo->prepare('DELETE FROM user_theory_attempts WHERE user_id = :uid AND bank_id = :bid');
  $stmt->execute([':uid' => (string)$me['id'], ':bid' => $bankId]);

  json_response([
    'success' => true,
    'data' => [
      'reset' => true,
      'bankId' => $bankId,
    ],
  ]);
} catch (Throwable $e) {
  json_response([
    'success' => false,
    'error' => 'Failed to reset theory bank',
    'detail' => $e->getMessage(),
  ], 500);
}
