<?php
declare(strict_types=1);

require_once __DIR__ . '/../response.php';
require __DIR__ . '/../config.php';
require_once __DIR__ . '/../helpers.php';
require_once __DIR__ . '/../auth.php';

if (($_SERVER['REQUEST_METHOD'] ?? '') !== 'GET') {
  json_response(['success' => false, 'error' => 'Method not allowed'], 405);
}

$me = require_auth($pdo);
$role = (string)($me['role'] ?? 'student');

if ($role !== 'admin' && $role !== 'course_rep') {
  json_response(['success' => false, 'error' => 'Uploader access required'], 403);
}

$courseId = isset($_GET['courseId']) ? trim((string)$_GET['courseId']) : '';

// For reps, if a courseId filter is provided, ensure it's within their scope.
if ($role === 'course_rep' && $courseId !== '') {
  require_uploader($pdo, $me, $courseId);
}

$baseSelect = 'SELECT m.id,
                     m.course_id AS courseId,
                     m.title,
                     m.type,
                     m.file_path,
                     m.uploaded_at AS uploadedAt,
                     m.tags,
                     m.created_by AS createdBy,
                     u.full_name AS createdByName,
                     u.email AS createdByEmail
              FROM materials m
              LEFT JOIN users u ON u.id = m.created_by';

if ($role === 'admin') {
  if ($courseId !== '') {
    $stmt = $pdo->prepare($baseSelect . ' WHERE m.course_id = :c ORDER BY m.uploaded_at DESC');
    $stmt->execute([':c' => $courseId]);
  } else {
    $stmt = $pdo->query($baseSelect . ' ORDER BY m.uploaded_at DESC');
  }
  $rows = $stmt->fetchAll() ?: [];
} else {
  // course rep: only their uploads
  if ($courseId !== '') {
    $stmt = $pdo->prepare($baseSelect . ' WHERE m.created_by = :uid AND m.course_id = :c ORDER BY m.uploaded_at DESC');
    $stmt->execute([':uid' => $me['id'], ':c' => $courseId]);
  } else {
    $stmt = $pdo->prepare($baseSelect . ' WHERE m.created_by = :uid ORDER BY m.uploaded_at DESC');
    $stmt->execute([':uid' => $me['id']]);
  }
  $rows = $stmt->fetchAll() ?: [];
}

$items = array_map(function($r){
  $r['fileUrl'] = public_url((string)$r['file_path']);
  unset($r['file_path']);
  $r['tags'] = json_get($r['tags'] ?? null, []);
  return $r;
}, $rows);

json_response(['success' => true, 'data' => ['items' => $items]]);
